clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-07-22_15-45-40.txt';
file2 = 'C2_2025-07-22_14-55-12.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
filename2 = fullfile(folderPath, file2);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
data_import_2 = importdata(filename2,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);
data2=data_import_2.data(5:end,:);
disp(data_import_2);

%% GRAFICI
%BANK
figure(1)

subplot(3,1,1)
plot(data1(:,1)-data1(1,1),data1(:,9),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1),data1(:,8),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,8),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('bank [deg]');
legend('com','response','nominal', 'Location', 'southeast');
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 800]) % [x, y, width, height]
ylim([-21 1])

subplot(3,1,2)
plot(data1(:,1)-data1(1,1),data1(:,14),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,14),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('\deltaa [deg]');
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
ylim([-6 6])

subplot(3,1,3)
plot(data1(:,1)-data1(1,1),data1(:,27),"k", 'LineWidth', 1.5)
hold on
plot(data2(:,1)-data2(1,1),data2(:,27),"--r", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('wind [m/s]');
ylim([-15 15])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
